import sys
from string import join
from numpy import *
from math import acos
import numpy.linalg as la

def adjoint(mat):
  return conjugate(transpose(mat))

def check_unitarity(u,v):   #sanity check for u,v matrices
  N=len(u[:,0])
  unit=dot(conjugate(v),transpose(v))+dot(u,conjugate(transpose(u)))
  for i in range(N):
    for j in range(N):
     if i == j :
       if abs(unit[i,i]-1) > 0.0001 :
         print N,i,unit[i,i]
         raise Exception
     else : 
       if abs(unit[i,j]) > 0.0001 :
         print shape(u),i,j,unit[i,j]
         raise Exception   

def read_uv(Ndim,filename):     # read in initial u,v, set
  lines=open(filename).readlines()
  idx=0
  uL=[]
  vL=[]
  for N in Ndim :
    u=zeros(shape=(N,N) )
    v=zeros(shape=(N,N))
    Np=int(lines[idx][:5])
    idx +=1
    if N != Np : raise Exception
    for i in range(N):
      ss=lines[idx].split()
      idx += 1
      for j in range(N):
        u[i,j] = float(ss[j])
    for i in range(N):
      ss=lines[idx].split()
      idx += 1
      for j in range(N):
        v[i,j] = float(ss[j])
    check_unitarity(u,v)
    uL.append(u)
    vL.append(v)
  return uL,vL

def mk_complex(mL):
 mcL = []
 for b in range(len(mL)) :
   m=mL[b]
   Nd=shape(m)[0]
   mc=array([[0.0j]*Nd]*Nd)
   mc += m
   mcL.append(mc)
 return mcL

def read_uvc(Ndim,filename):
  u0L,v0L = read_uv(Ndim,filename)
  u0cL = mk_complex(u0L); v0cL = mk_complex(v0L)   
  return u0cL,v0cL  

def pfaff_py(m) :
#  reference to be cited:  Computer Physics Communications 182 2213 (2011)
  mat=copy(m)
  ndim = shape(mat)[0]
  t1=1.0
  for j in range(ndim/2) :
    ndim_r=shape(mat)[0]
    kp=1;    pvt=abs(mat[0,1])      #pivot
    for k in range(2,ndim_r) :
      if abs(mat[0,k]) > pvt :
        kp= k;    pvt = abs(mat[0,k])
    if kp != 1 :
      tv=mat[:,1]*1.0
      mat[:,1] = mat[:,kp]*1.0
      mat[:,kp]=tv
      tv=mat[1,:]*1.0
      mat[1,:] = mat[kp,:]*1.0
      mat[kp,:]=tv
      t1 = -t1
    t1 *= mat[0,1]
    if j <ndim/2-1 :
      for i in range(2,ndim_r) :            #row and column reduction
        if mat[0,1] != 0.0 :
          tv=mat[1,:]*mat[i,0]/mat[1,0]
          mat[i,: ] -= tv
          tv=mat[:,1]*mat[0,i]/mat[0,1]
          mat[:,i ] -= tv
        else :
          t1=0.0
          break
      mat=mat[2:,2:] 
  return t1


def fac(n):
  ff=array([0.0]*(n+1))
  ff[0]=1.0
  for i in range(1,n+1) :
    ff[i] = i*ff[i-1]
  return ff


def dj(jmax2,cs0):
# jmax2 is twice maximum j
# formulas from Edmonds, Eqs. 4.1.27, 4.4.1
  ff=fac(2*jmax2)
  beta=acos(cs0)
  cs=cos(beta/2.)
  sn=sin(beta/2.)
  djmmL=[]
  djmmL.append(array([[1.0]*1]*1))   # J=0
  djmmL.append(array([[cs,-sn],[sn,cs]]))   # J=1/2
  djmm0=djmmL[1]
  for j2 in range(2,jmax2+1):
    djmm =array([[0.0]*(j2+1)]*(j2+1))
    for m2 in range(-j2,j2+1,2):       #  do border, Eq. 4.1.27
      jm2=(j2+m2)/2
      t1=(ff[j2]/ff[jm2]/ff[(j2-m2)/2])**0.5
      t2=t1*cs**(jm2)*(-sn)**((j2-m2)/2)
      djmm[jm2,j2]=t2
      jmb2=j2-jm2
      if jm2 != 0 : 
        djmm[0,jmb2]=t2
        djmm[j2,jm2]=abs(t2)
      djmm[jmb2,0] = abs(t2)
    for m2 in range(-j2+2,j2-1,2):      # do inside Eq. 4.4.1
      for mp2 in range(-j2+2,j2-1,2):
        t1=(float(j2-mp2)/float(j2-m2))**0.5
        t2=(float(j2+mp2)/float(j2-m2))**0.5
        jmp2=(j2+mp2)/2; jm2=(j2+m2)/2
        djmm[jmp2,jm2] = t1*cs*djmm0[jmp2,jm2]
        djmm[jmp2,jm2] += t2*sn*djmm0[jmp2-1,jm2] # note sign 
    djmmL.append(djmm)
    djmm0=djmm
  return djmmL

    

def mk_Rot(Z0L,jlist,csb):
  if csb < -0.999: csb = -0.999
  djmmL = dj(5,csb)
  Nd = shape(Z0L[0])[1]
  Rot=array([[0.0]*Nd]*Nd)
  istart = 0
  for j in jlist[0]:
    iend = istart+j+1
    Rot[istart:iend,istart:iend] = transpose(djmmL[j])
    istart=iend
  return Rot

 
def GL(m,tol=10e-9):
 
    def legendre(t,m):
        p0 = 1.0; p1 = t
        for k in range(1,m):
            p = ((2.0*k + 1.0)*t*p1 - k*p0)/(1.0 + k )
            p0 = p1; p1 = p
        dp = m*(p0 - t*p1)/(1.0 - t**2)
        return p,dp
 
    w = zeros(m)   
    x = zeros(m)   
    nRoots = (m + 1)/2          # Number of non-neg. roots
    for i in range(nRoots):
        t = cos(pi*(i + 0.75)/(m + 0.5))  # Approx. root
        for j in range(30): 
            p,dp = legendre(t,m)          # Newton-Raphson
            dt = -p/dp; t = t + dt        # method         
            if abs(dt) < tol:
                x[i] = t; x[m-i-1] = -t
                w[i] = 2.0/(1.0 - t**2)/(dp**2) # Eq.(6.25)
                w[m-i-1] = w[i]
                break
    return x,w

