''' Carries out the projection integrals

input:  olp.dat, table of overlap integrals <qw|R|qw> as a function 
of gauge angle and rotation angle.

output, with default input:
$python nzj_project.py 
4 1 5 1
   N      J   olp 
   1   0  3  0.000000 0.000000
   1   0  5  0.640000 0.000000
   3   0  3  0.051429 0.000000
   3   0  5  0.180000 0.000000
   3   0  7  -0.000000 0.000000
   3   0  9  0.128572 0.000000
'''

import sys,os
from numpy import *
from utilities import dj,GL

lines = open('olp.out').readlines()
Ngrid,Zgrid,Rgrid,Kqp = map(int,lines[0].split()[:4])
print Ngrid,Zgrid,Rgrid,Kqp
phiNs = array([0.0]*Ngrid)
for i in range(Ngrid):
  phiNs[i] = i*pi/Ngrid


css,wtR = GL(Rgrid)
Ntot=Ngrid*Zgrid*Rgrid
olpsk = array([0.0j]*Ntot)
for i in range(Ntot) :
  olpkr,olpki = map(float,lines[i+1].split()[:2])
  olpsk[i] = olpkr + 1.0j*olpki
print '   N      J   olp '
for nzj in ((1,0,3),(1,0,5),(3,0,3),(3,0,5),(3,0,7),(3,0,9)):
   N,Z,J = nzj
   olp = 0.0
   Nproj = 0.0
   for i in range(Ngrid):
     wtNZ=exp(-1.0j*N*phiNs[i])/Ngrid
     for k in range(Rgrid):
       csb=css[k]
       if csb < -0.99999 : csb = -0.99999
       djmm = dj(J,csb)
       d5 = djmm[J]
       i1=(J-Kqp)/2
       t1=d5[i1,i1]
       wolp =  t1*wtNZ*olpsk[k + Rgrid*Zgrid*i]
       olp += wolp*wtR[k]; 
#       print csb,real(olpsk[k+Rgrid*Zgrid*i]),t1,wtR[k],real(wolp),real(olp)
   ss=' %3i %3i %2i  %8.6f %8.6f' %(N,Z,J,real(olp*(J+1)/2.),imag(olp*(J+1)/2.))
   print ss
