''' <qw|R|qw> calculated by Eq. 5 of
Bertsch and Robledo

input:  input.dat
output:  olp.dat, the table of overlaps as a function of gauge angle 
                  and rotation angle.
'''
import sys
from numpy import *
import numpy.linalg as la
from utilities import read_uvc,dj,pfaff_py,mk_Rot,adjoint,GL

def olp(Rot,u0L,v0L ) :      # Equation 5
  Nd,Nq = shape(u0L[0])
  M=array([[0.0j]*Nq*2]*Nq*2)
  M[:Nq,:Nq] = dot(transpose(v0L[0]),u0L[0])     
  M[Nq:2*Nq,Nq:2*Nq] = adjoint(M[:Nq,:Nq])
  t1= conjugate(dot(Rot,v0L[0])) 
  M[:Nq,Nq:2*Nq] = dot(transpose(v0L[0]),t1)
  for i1 in range(Nq):
    for i2 in range(Nq,2*Nq):
      M[i2,i1] = - M[i1,i2]
  sign = -1**(Nq+1)
  return sign*pfaff_py(M)


lines=open('input5.dat').readlines()
for line in lines:
  print line,
nzj_out=open('olp.out','w')
jlist= ((5,3,1),(5,3,1))
Ndim=(12,12)
Nb=2
u0L,v0L = read_uvc(Ndim,lines[0].split()[0])
Ngrid = int(lines[1].split()[0])
#Zgrid  = int(lines[2].split()[0])
Zgrid = 1
Rgrid = int(lines[2].split()[0])
Kqp=int(lines[3].split()[0])
ss=' %3i %3i %3i %3i\n' % (Ngrid,Zgrid,Rgrid,Kqp)
nzj_out.write(ss)
#remove columns for which u=1.0
utL=[]; vtL= []
for b in range(len(u0L)):
  u0= u0L[b]; v0=v0L[b]
  Nq = 0
  for i in range(Ndim[b]):
    if u0[i,i] != 1.0 :
      Nq += 1
  ut=array([[0.0j]*Nq]*Ndim[b])
  vt=array([[0.0j]*Nq]*Ndim[b])
  idx = 0
  for i in range(Ndim[b]):
    if u0[i,i] != 1.0 :
      ut[:,idx] = u0[:,i]
      vt[:,idx] = v0[:,i]
      idx += 1
  utL.append(ut); vtL.append(vt)    

csbs,wtbs = GL(Rgrid)        # Gauss-Legendre

Rot = mk_Rot(u0L,jlist,1.0)
vprod = olp(Rot,utL,vtL)
print vprod
for i in range(Ngrid):
  phiN = i*pi/Ngrid
  for j in range(Zgrid):
    phiZ = j*pi/Zgrid
    for k in range(Rgrid) :
      if Rgrid == 1 :
        csb = 1.0
      else:
        csb=csbs[k]
      Rot = mk_Rot(u0L,jlist,csb)
      Rot = Rot*e**(-1.0j*phiN)
      olp_raw = olp(Rot,utL,vtL)
      olpk = olp_raw/vprod         
      ss=' %8.6f %8.6f\n' %  (real(olpk),imag(olpk))
      print csb,ss,
      nzj_out.write(ss)
